<?php
/**
* Plugin Name: Disable Comments by click5
* Plugin URI: https://www.click5interactive.com/wordpress-disable-comments-plugin/
* Description: Disable comments on your website and protect yourself from spammers.
* Version: 1.0.5
* Author: click5 Interactive
* Author URI: https://www.click5interactive.com/?utm_source=comments-plugin&utm_medium=plugin-list&utm_campaign=wp-plugins
* Text Domain: disable-comments-by-click5
* Domain Path: /languages
**/

define('click5_disable_comments_VERSION', '1.0.5');
define('click5_disable_comments_DEV_MODE', true);
define( 'CLICK5_DISABLE_COMMENTS_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
add_filter('xmlrpc_enabled', '__return_false');

//get post type
function click5_disable_comments_get_post_types($at_least = 1) {
  $post_types = get_post_types(array('public' => true), 'names');
  $result_post_types = array();

  foreach($post_types as $post_type) {

    if (post_type_supports($post_type, 'comments')) {
      $result_post_types[] = $post_type;
    }
  
  }

  return $result_post_types;
}

add_action( 'plugins_loaded', 'init_disable_comments_by_click5' );
 
function init_disable_comments_by_click5() 
{
  global $wpdb;

  if(get_option("click5_disable_comments_display_rpc")=="1")
  {
    //add_filter('xmlrpc_methods',  'click5_disable_rpc_comments', 20, 2);   
    
    update_option( 'default_ping_status', 'closed' );
    add_filter('pings_open', '__return_false', 20, 2);
    add_filter( 'xmlrpc_methods', '__return_empty_array', PHP_INT_MAX );
    add_filter( 'wp', 'click5_disable_comments_remove_xmlprc_header', PHP_INT_MAX, 0 );
    add_filter( 'pings_open', '__return_false', PHP_INT_MAX, 2 );
    add_filter('xmlrpc_enabled', '__return_false');

    // Close comments on the front-end
    //add_filter('comments_open', '__return_false', 20, 2);
    add_filter('pings_open', '__return_false', 20, 2);
    add_filter('pre_option_default_pingback_flag', '__return_zero');
   
  }

  if(get_option("click5_disable_comments_display_api")=="1")
  {
    add_filter('rest_pre_insert_comment',  'click5_disable_api_comments', 20, 2);
    // Disable Comments REST API Endpoint
		add_filter('rest_endpoints','click5_disable_comments_endpoints', 20, 2);
  }

  if(get_option('click5_disable_comments_display_globally')=="1")
  {
    global $pagenow;
    global $submenu;
    if ($pagenow === 'edit-comments.php') {
        wp_redirect(admin_url());
        exit;
    }

    // Disable support for comments and trackbacks in post types
    foreach (get_post_types() as $post_type) 
    {
      if (post_type_supports($post_type, 'comments')) 
      {
          remove_post_type_support($post_type, 'comments');
          remove_post_type_support($post_type, 'trackbacks');
      }
    }  
      // Close comments on the front-end
    add_filter('comments_open', '__return_false', 20, 2);
    add_filter('pings_open', '__return_false', 20, 2);

    // Hide existing comments
    add_filter('comments_array', '__return_empty_array', 10, 2);
    
    add_filter('pings_open', '__return_false', 20, 2);
    update_option("default_comment_status", "closed");    
    
    add_filter('pre_option_default_pingback_flag', '__return_zero');
    add_action('wp_dashboard_setup', 'click5_filter_dashboard');
    add_filter('comments_array', '__return_empty_array', 10, 2);
   
    update_option ('comments_notify', 0);
    update_option ('moderation_notify', 0);
    add_action( 'admin_menu', 'click5_remove_meta_boxes' ); 

     // Remove comments page in menu
     add_action('admin_menu', function () {
     remove_menu_page('edit-comments.php');
     
     add_action( 'admin_footer', 'remove_pings_and_comments_quickedit', 1, 0 );
      });    
  }
  
}

//SITEHEALTH INTEGRATION START //
add_filter( 'site_status_tests', function($tests){
  if(array_key_exists("direct",$tests)){
    $tests['direct']['test_c5_disable_comments'] = array("label" => "Disable Comments by click5", "test"=>"click5_disable_comments_healthcheck");
  }
  
  return $tests;
});


function click5_disable_comments_healthcheck(){
  $result = array(
    'label'       => 'Disable Comments by click5',
    'status'      => 'good',
    'badge'       => array(
        'label' => __( 'Disable Comments' ),
        'color' => 'blue',
    ),
    'description' => sprintf(
        '<p>%s</p>',
        __( 'We didn’t find any issues with your XML-RPC and REST API comments' )
    ),
    'actions'     => '',
    'test'        => 'click5_disable_comments_healthcheck',
);

  if(esc_attr(get_option("click5_disable_comments_display_rpc")) !== "1" && esc_attr(get_option("click5_disable_comments_display_api")) !== "1"){
    $result['label'] = "Your website is exposed to potential external spam comments made via XML-RPC and REST API";
    $result['status'] = "critical";
    $result['description'] = sprintf(
      '<p>%s</p><p>%s</p>',
      __( 'We recommend disabling external comments made via XML-RPC and REST API in order to prevent potential spam from automated bots.','disable-comments-by-click5'),
      __('<a href="'.admin_url('admin.php?page=disable-comments-by-click5').'">Disable Now</a>')
    );
  }else if(esc_attr(get_option("click5_disable_comments_display_api")) !== "1"){
    $result['label'] = "Your website is exposed to potential external spam comments made via REST API";
    $result['status'] = "critical";
    $result['description'] = sprintf(
      '<p>%s</p><p>%s</p>',
      __( 'We recommend disabling external comments made via REST API in order to prevent potential spam from automated bots.','disable-comments-by-click5'),
      __('<a href="'.admin_url('admin.php?page=disable-comments-by-click5').'">Disable Now</a>')
    );
  }else if(esc_attr(get_option("click5_disable_comments_display_rpc")) !== "1"){
    $result['label'] = "Your website is exposed to potential external spam comments made via XML-RPC";
    $result['status'] = "critical";
    $result['description'] = sprintf(
      '<p>%s</p><p>%s</p>',
      __( 'We recommend disabling external comments made via XML-RPC in order to prevent potential spam from automated bots.','disable-comments-by-click5'),
      __('<a href="'.admin_url('admin.php?page=disable-comments-by-click5').'">Disable Now</a>')
    );
  }

return $result;
}

//SITEHEALTH INTEGRATION END //


add_action('widgets_init', 'click5_disable_rc_widget');
add_action('template_redirect', 'click5_filter_query');   // before redirect_canonical.

// Admin bar filtering has to happen here since WP 3.6.
add_action('template_redirect','click5_filter_admin_bar');
add_action('admin_init', 'click5_filter_admin_bar');

function click5_remove_meta_boxes() {
  remove_meta_box( 'commentstatusdiv' , 'page' , 'normal' ); //removes comments status
  remove_meta_box( 'commentsdiv' , 'page' , 'normal' ); //removes comments
  remove_meta_box( 'trackbacksdiv', 'post', 'side' );
  remove_meta_box( 'commentstatusdiv', 'post', 'normal' );
  remove_meta_box( 'commentsdiv', 'post', 'normal' );
  remove_meta_box('dashboard_recent_comments', 'dashboard', 'normal'); // Recent Comments
  //remove_meta_box( 'dashboard_activity', 'dashboard', 'normal');
  
}


function remove_pings_and_comments_quickedit() 
{    
    ?>
  
  <script type="text/javascript">   
   console.log(document);
   var comments = document.getElementById("latest-comments");
   if(comments!=null){
    comments.style.display = "none";
   }
    </script>
    <?php
}

function click5_filter_dashboard()
	{
		remove_meta_box('dashboard_recent_comments', 'dashboard', 'normal');
	}


function click5_filter_query()
	{
		if (is_comment_feed()) {
			wp_die(__('Comments are closed.', 'click5_disable_comments'), '', array('response' => 403));
		}
	}

  function click5_filter_admin_bar()
	{
		if (is_admin_bar_showing()) {
			// Remove comments links from admin bar.
			remove_action('admin_bar_menu', 'wp_admin_bar_comments_menu', 60);
			if (is_multisite()) {
				add_action('admin_bar_menu', 'remove_network_comment_links', 500);
			}
		}
	}

function click5_disable_rc_widget()
{
  unregister_widget('WP_Widget_Recent_Comments');
  /**
   * The widget has added a style action when it was constructed - which will
   * still fire even if we now unregister the widget... so filter that out
   */
  add_filter('show_recent_comments_widget_style', '__return_false');
}



function click5_disable_comments_remove_xmlprc_header() {
	header_remove( 'X-Pingback' );
}

function click5_disable_comments_endpoints($endpoints)
	{
    unset($endpoints['comments']);
    unset($endpoints['/wp/v2/comments']);
		return $endpoints;
	}

function click5_disable_rpc_comments_call($method)
{
		return ;
}

function click5_disable_rpc_comments($methods)
{
		unset($methods['wp.newComment']);  
		return $methods;
}

function click5_disable_api_comments($prepared_comment, $request)
{
		return;
}


//disable comments functions
add_filter( 'comments_array', 'click5_disable_comments_filter_existing_comments', 20, 2 );
function click5_disable_comments_filter_existing_comments($comments, $post_id) {
  $post = get_post( $post_id );
  $type = $post->post_type;
  $mystring = $post->guid;
  $findme   = 'page_id';
  $res = strpos($mystring, $findme);
  $option_name = 'click5_disable_comments_display_'.$type;

      if(get_option('click5_disable_comments_display_globally')=="1"){
        add_filter('comments_template', 'click5_disable_comments_empty_comments_template', 20);
        return array() ;
      }
      else if(get_option($option_name)=="1"){
        add_filter('comments_template', 'click5_disable_comments_empty_comments_template', 20);
        return array() ;
      }
      else{
        return $comments;
      }
      return $comments;
}

add_filter( 'wp_disable_comments_by_click5_enabled', '__return_false' );


function click5_disable_comments_empty_comments_template()
{
		return dirname(__FILE__) . '/comments.php';
}

//end of disable comments functions

/*
add_action( 'admin_init', function(){
  $value = intval(get_option("click5_disable_comments_force_autoupdate"));
  if(!is_null($value))
  {
    if(boolval($value) == true){
      click5_disable_comments_auto_update();
      update_option("click5_disable_comments_force_autoupdate","0");
    }

  }else{
    click5_disable_comments_auto_update();
    update_option("click5_disable_comments_force_autoupdate", "0");
  }
});
*/

function click5_disable_comments_upgrade_completed( $upgrader_object, $options ) {
  $our_plugin = plugin_basename( __FILE__ );
  if( $options['action'] == 'update' && $options['type'] == 'plugin' && isset( $options['plugins'] ) ) {
   foreach( $options['plugins'] as $plugin ) {
    if( $plugin == $our_plugin ) {
        update_option('click5_disable_comments_force_autoupdate', "1");
      }
   }
  }
}

add_action( 'upgrader_process_complete', 'click5_disable_comments_upgrade_completed', 10, 2 );



/*function click5_disable_comments_auto_update ( ) {
  $pluginName = plugin_basename(__FILE__);
  	$options = get_option("auto_update_plugins");
    foreach($options as $key=>$value){
      if($value == $pluginName)
        return;
    }
      $options[] = $pluginName;
      update_option("auto_update_plugins",$options);
  }*/
//add_action( 'auto_update_plugin', 'click5_disable_comments_auto_update', 10, 2 );

add_filter( 'custom_menu_order', 'submenu_order' );
function submenu_order( $menu_order ) {
    # Get submenu key location based on slug
    global $submenu;
    unset( $submenu['options-general.php'][25] ); // removes discussion
    $settings = $submenu['options-general.php'];
    foreach ( $settings as $key => $details ) {
        if ( $details[0] == 'Disable Comments' ) {
            $index = $key;
        }
    }
    # Set the 'Disable' menu below 'Reading'
    $submenu['options-general.php'][21] = $submenu['options-general.php'][$index];
    unset( $submenu['options-general.php'][$index] );
    # Reorder the menu based on the keys in ascending order
    ksort( $submenu['options-general.php'] );
    # Return the new submenu order
    return $menu_order;
}


add_action('admin_menu', 'click5_disable_comments_create_menu');

function click5_disable_comments_create_menu() {
  //create submenu in Settings
  add_submenu_page('options-general.php','Disable Comments', 'Disable Comments', 'manage_options','disable-comments-by-click5','click5_disable_comments_settings_page' );
	//call register settings function
	add_action( 'admin_init', 'click5_disable_comments_settings' );
}

function click5_disable_comments_activation_redirect( $plugin ) {
  if( $plugin == plugin_basename( __FILE__ ) ) {
      exit( wp_redirect( admin_url( 'options-general.php?page=disable-comments-by-click5' ) ) );
  }
}
add_action( 'activated_plugin', 'click5_disable_comments_activation_redirect' );

add_filter('plugin_action_links_'.plugin_basename(__FILE__), 'click5_disable_comments_add_plugin_page_settings_link');
function click5_disable_comments_add_plugin_page_settings_link( $links ) {
	$links[] = '<a href="' .
		admin_url( 'options-general.php?page=disable-comments-by-click5' ) .
		'">' . __('Settings') . '</a>';
	return $links;
}

add_filter( 'plugin_row_meta', 'click5_disable_comments_plugin_meta', 10, 2 );
function click5_disable_comments_plugin_meta( $links, $file ) { // add some links to plugin meta row
	if ( strpos( $file, 'disable-comments-by-click5.php' ) !== false ) {
    array_splice( $links, 2, 0, array( '<a href="https://www.click5interactive.com/disable-comments-wordpress-plugin/?utm_source=comments-plugin&utm_medium=plugin-list&utm_campaign=wp-plugins" target="_blank" rel="nofollow">About plugin</a>' ) );
	}
	return $links;
}

// Activation
function click5_disable_comments_activation(){
    do_action( 'click5_disable_comments_default_options' );
}
register_activation_hook( __FILE__, 'click5_disable_comments_activation' );

function click5_disable_comments_forceDefaultSettings() {
  $post_types = click5_disable_comments_get_post_types();
  foreach($post_types as $single_type) {
    $single_type = get_post_type_object($single_type);
    $option_name = 'click5_disable_comments_display_'.$single_type->name;
    update_option($option_name, false);
  }

  update_option("click5_disable_comments_display_globally", true);
  update_option("click5_disable_comments_display_rpc", true);
  update_option("click5_disable_comments_display_api", true);
  update_option("click5_disable_comments_force_autoupdate", "1");

  update_option("default_comment_status", "closed");

  register_setting( 'click5_disable_comments', 'click5_disable_comments_activation_date' );
  update_option("click5_disable_comments_activation_date", date("Y-m-d"));
}

add_action( 'click5_disable_comments_default_options', 'click5_disable_comments_forceDefaultSettings' );


function click5_disable_comments_settings() {
  
  
  //register our settings
  register_setting( 'click5_disable_comments', 'click5_disable_comments_display_globally' );
  register_setting( 'click5_disable_comments', 'click5_disable_comments_display_rpc' );
  register_setting( 'click5_disable_comments', 'click5_disable_comments_display_api' );
  register_setting( 'click5_disable_comments', 'click5_disable_comments_force_autoupdate');
  $option_names1 = array('click5_disable_comments_use_custom_name_globally', 'click5_disable_comments_custom_name_text_globally');
  register_setting('click5_disable_comments', $option_names1[0]);
  register_setting('click5_disable_comments', $option_names1[1]);
  $post_types = click5_disable_comments_get_post_types();

  foreach($post_types as $single_type) {
    $single_type = get_post_type_object($single_type);
    $option_name = 'click5_disable_comments_display_'.$single_type->name;
    $option_names = array('click5_disable_comments_use_custom_name_'.$single_type->name, 'click5_disable_comments_custom_name_text_'.$single_type->name);

    register_setting('click5_disable_comments', $option_name);
    register_setting('click5_disable_comments', $option_names[0]);
    register_setting('click5_disable_comments', $option_names[1]);

    if(get_option('click5_disable_comments_display_globally')=="1"){
      update_option("default_comment_status", "closed");
    }
  }

  //for authentication purposes
  $current_user = wp_get_current_user();
  register_setting('click5_disable_comments_authentication', 'click5_disable_comments_authentication_token_'.wp_get_current_user()->user_login);
}

function click5_disable_comments_load_plugin_textdomain() {
  load_plugin_textdomain( 'disable-comments-by-click5', FALSE, basename( dirname( __FILE__ ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'click5_disable_comments_load_plugin_textdomain' );


function click5_disable_comments_settings_page() {
?>
<div class="wrap">
  <h1 class="click5_disable_comments_heading"><?php _e('Disable Comments by click5 Settings', 'disable-comments-by-click5'); ?>&nbsp;<span class="version">v<?php echo click5_disable_comments_VERSION; ?></span></h1>
</div>
<?php if( isset($_GET["settings-updated"]) ) { ?>
<div id="message" class="updated">
<p><strong><?php _e("Settings saved."); ?></strong></p>
</div>
<?php } ?>
<?php
            if( isset( $_GET[ 'tab' ] ) ) {
                $active_tab = sanitize_key($_GET[ 'tab' ]);
            } else {
              $active_tab = 'html';
            }
?>

<div class="wrap click5_disable_comments_wrapper_content_settings" style="margin-right: 20px">
<div class="content-left" style="margin-right: 20px">
<?php
      $verification_token = md5(uniqid(rand(), true));
      $cur_user_id = wp_get_current_user()->user_login;
      update_option('click5_disable_comments_authentication_token_'.$cur_user_id, $verification_token);
?>
<input type="hidden" id="verification_token" value="<?php echo esc_attr($verification_token); ?>" />
<input type="hidden" id="user_identificator" value="<?php echo esc_attr($cur_user_id); ?>" />
<form method="post" action="options.php">
    <?php settings_fields( 'click5_disable_comments' ); ?>
    <?php do_settings_sections( 'click5_disable_comments' ); ?>
    <div id="poststuff">     
        <div class="postbox" id="enableSitemap">
          <h3 class="hndle"><span><?php _e('Disable Comments Settings', 'disable-comments-by-click5'); ?></span></h3>
          <div class="inside">
            <p><?php _e('Disable comments globally for all post types (builtin and custom) or select individual post types:', 'disable-comments-by-click5'); ?></p>
            <div class="form-table">
              <div class="click5_disable_comments_post_type_item" style="padding-left:10px">
              <?php $option_name = 'click5_disable_comments_display_globally'?>
              <label for="globally">
              <label for="<?php echo esc_attr($option_name); ?>">
                  <input class="global_disable" type="checkbox" name="<?php echo esc_attr($option_name); ?>" id="<?php echo esc_attr($option_name); ?>" value="1" <?php echo (intval(esc_attr( get_option($option_name) )) == 1 ? 'checked' : ''); ?>>
                  <strong>Globally</strong></label>
                  <p style="padding-left:25px"><span style="color:red">Warning:</span> This will disable comments on every page and post of your website. Use this setting only, if you do not want to show comments anywhere.</p>
              </div>
              </div>
              <hr style="width:100%;text-align:left;margin-left:0">
              <div class="form-table">
              <div class="click5_disable_comments_post_type_item" style="padding-left:10px">
              <?php
                $post_types = click5_disable_comments_get_post_types();
                foreach($post_types as $single_type) {
                  $single_type = get_post_type_object($single_type);
              ?>
              <?php $option_name = 'click5_disable_comments_display_'.$single_type->name; ?>
              <label for="<?php echo esc_attr($option_name); ?>">
                  <input class="other_disable" type="checkbox" name="<?php echo esc_attr($option_name); ?>" id="<?php echo esc_attr($option_name); ?>" value="1" <?php echo (intval(esc_attr( get_option($option_name) )) == 1 ? 'checked' : ''); ?>>
                  <strong><?php echo esc_attr($single_type->label); ?></strong></label> &nbsp&nbsp&nbsp
               <?php } ?>
               </div>
               </div>
              
          </div>
        </div>         
        <div class="postbox" id="enableSitemap">
          <h3 class="hndle"><span><?php _e('Disable External Comments', 'disable-comments-by-click5'); ?></span></h3>
          <div class="inside">
            <p><?php _e('Disable external comments made via XML-RPC or REST API:', 'disable-comments-by-click5'); ?></p>
            
            <div class="form-table">
            
              <div class="click5_disable_comments_post_type_item" style="padding-left:10px">
              <?php $option_name = 'click5_disable_comments_display_rpc'?>
              <label for="rpc">
              <label for="<?php echo esc_attr($option_name); ?>">
                  <input type="checkbox" name="<?php echo esc_attr($option_name); ?>" id="<?php echo esc_attr($option_name); ?>" value="1" <?php echo (intval(esc_attr( get_option($option_name) )) == 1 ? 'checked' : ''); ?>>
                  <strong>Disable XML-RPC Comments</strong></label>
                  
              </div>
              <div class="click5_disable_comments_post_type_item" style="padding-left:10px">
              <?php $option_name = 'click5_disable_comments_display_api'?>
              <label for="api">
              <label for="<?php echo esc_attr($option_name); ?>">
                  <input type="checkbox" name="<?php echo esc_attr($option_name); ?>" id="<?php echo esc_attr($option_name); ?>" value="1" <?php echo (intval(esc_attr( get_option($option_name) )) == 1 ? 'checked' : ''); ?>>
                  <strong>Disable REST API Comments</strong></label>
                  
              </div>
              </div>
          </div>
        </div>
     
      </div>
    <?php 
        submit_button();
    ?>
    
</form>
</div>
<div class="content-right content-right-width">
      <div id="poststuff">
        <div id="post-body-content">
            <div class="postbox">
              <h3 class="hndle"><span>Plugin Support</span></h3>
              <div class="inside">
                <p>Visit our <a href="http://wordpress.org/support/plugin/disable-comments-by-click5" target="_blank" rel="nofollow">community forum</a> to find answers to common issues, ask questions, submit bug reports, feature suggestions and other tips about our plugin.</p>
                <p>Please consider supporting our plugin by <a href="https://wordpress.org/support/plugin/disable-comments-by-click5/reviews/?filter=5" target="_blank" rel="nofollow">leaving a review</a>. Thank You!</p>
              </div>
            </div>
            <?php
             $currentMonth = new DateTime(); 
             $currentMonth->setTimezone(new DateTimeZone(wp_timezone_string()));
             //$currentMonth->setTimestamp(strtotime("+1 month"));
             $currentMonth = $currentMonth->format('m');

             $monthSwitch = intval($currentMonth%3);

             $c5SiteMap_Pathpluginurl = WP_PLUGIN_DIR . '/sitemap-by-click5/sitemap-by-click5.php';
             $c5SiteMap_IsInstalled = file_exists( $c5SiteMap_Pathpluginurl );

             $c5HistoryLog_Pathpluginurl = WP_PLUGIN_DIR . '/history-log-by-click5/history-log-by-click5.php';
             $c5HistoryLog_IsInstalled = file_exists( $c5HistoryLog_Pathpluginurl );
             $OtherWordpressPlugins = false;
             $AdImageURL = "assets/banner-300x515-sitemap-plugin.png";
             $AdImageSiteURL = "https://click5crm.com/?utm_source=comments-plugin&utm_medium=sidebar&utm_campaign=wp-plugins";
             $AdBoxSiteURL = "https://wordpress.org/plugins/sitemap-by-click5/";

             switch($monthSwitch){
              case 0:
                if($c5HistoryLog_IsInstalled === false){
                  $AdImageURL = "assets/baner-v01c.png";
                  $AdImageSiteURL = "https://wordpress.org/plugins/history-log-by-click5/";
                }else{
                  if($c5SiteMap_IsInstalled === false){
                      $AdImageURL = "assets/sitemap.png";
                      $AdImageSiteURL = "https://wordpress.org/plugins/sitemap-by-click5/";
                  }
                }
                break;

              case 1:
                if($c5SiteMap_IsInstalled !== false){
                  if($c5HistoryLog_IsInstalled === false){
                    $OtherWordpressPlugins = "historyLog";
                    $AdBoxSiteURL = "https://wordpress.org/plugins/history-log-by-click5/";
                  }
                }else{
                  if($c5HistoryLog_IsInstalled === false){
                    $OtherWordpressPlugins = "sitemap";
                    $AdBoxSiteURL = "https://wordpress.org/plugins/sitemap-by-click5/";
                  }else{
                    $OtherWordpressPlugins = "sitemap";
                    $AdBoxSiteURL = "https://wordpress.org/plugins/sitemap-by-click5/";
                  }
                }
                break;

              case 2:
                if($c5SiteMap_IsInstalled === false){
                  $AdImageURL = "assets/sitemap.png";
                  $AdImageSiteURL = "https://wordpress.org/plugins/sitemap-by-click5/";
                }else{
                  if($c5HistoryLog_IsInstalled === false){
                    $AdImageURL = "assets/baner-v01c.png";
                    $AdImageSiteURL = "https://wordpress.org/plugins/history-log-by-click5/";
                  }
                }
                break;
             }

            
            ?>
            <div class="postbox with-image">
              <a href=<?php echo esc_url($AdImageSiteURL) ?> target="_blank" rel="nofollow">
                <img src="<?php echo plugin_dir_url( __FILE__ ).$AdImageURL; ?>" alt="click5crm">
              </a>
            </div>
            <?php
            if($OtherWordpressPlugins === "sitemap"){
            echo<<<HTML
            <div class="postbox">
              <h3 class="hndle"><span>Our Other WordPress Plugins</span></h3>
              <div class="inside">
                <p><strong><a href=$AdBoxSiteURL target="_blank" rel="nofollow">Sitemap by click5</a></strong></p>
                <p>Best plugin to generate and customize HTML & XML sitemaps for your website or blog.</p>
                <p><strong><a  href="https://wordpress.org/plugins/search/click5/" target="_blank" rel="nofollow">and more...</a</strong></p>
              </div>
            </div>
HTML;
            }else if($OtherWordpressPlugins === "historyLog"){
            echo<<<HTML
            <div class="postbox">
              <h3 class="hndle"><span>Our Other WordPress Plugins</span></h3>
              <div class="inside">
                <p><strong><a href=$AdBoxSiteURL target="_blank" rel="nofollow">History Log by click5</a></strong></p>
                <p>Best plugin to generate and customize HTML & XML sitemaps for your website or blog.</p>
                <p><strong><a  href="https://wordpress.org/plugins/search/click5/" target="_blank" rel="nofollow">and more...</a></strong></p>
              </div>
            </div>
HTML;
            }
            ?>
        </div>
      </div>
</div>
</div>
    <script>

        document.querySelector('.global_disable').addEventListener('click', function(e) {
            var cheboxList = document.querySelectorAll('.other_disable');
            cheboxList.forEach(function(navElement) {
                navElement.checked = false;
            })
          });


        var cheboxListOther = document.querySelectorAll('.other_disable');
        cheboxListOther.forEach(function (elementOther) {
            elementOther.addEventListener('click', function(e) {
                document.querySelector('.global_disable').checked = false;
            })
        })
        
    </script>
<?php }

function click5_disable_comments_init_admin_scripts() {
  //libraries
  $screen = get_current_screen();
  $version = click5_disable_comments_DEV_MODE ? time() : click5_disable_comments_VERSION;

  if(strpos($screen->base, 'disable-comments-by-click5') !== false) {

    wp_enqueue_style( 'click5_disable_comments_css_admin', plugins_url('/css/admin/index.css', __FILE__), array(), $version);

  }
  
}

add_action('admin_enqueue_scripts','click5_disable_comments_init_admin_scripts');

// uninstall hook

function click5_disable_comments_uninstallFunction() {
  delete_option('click5_disable_comments_display_globally');
  delete_option('click5_disable_comments_display_rpc');
  delete_option('click5_disable_comments_display_api');
  delete_option('click5_disable_comments_activation_date');
  delete_option('click5_disable_comments_force_autoupdate');


  
  $post_types = click5_disable_comments_get_post_types();
  foreach($post_types as $single_type) {
    $single_type = get_post_type_object($single_type);
    delete_option('click5_disable_comments_display_'.$single_type->name);
    delete_option('click5_disable_comments_use_custom_name_'.$single_type->name);
    delete_option('click5_disable_comments_custom_name_text_'.$single_type->name);
    delete_option('click5_disable_comments_seo_post_type_'.$single_type->name);
  }

  $current_user = wp_get_current_user();
  delete_option('click5_disable_comments_authentication_token_'.wp_get_current_user()->user_login);

  update_option ('comments_notify', 1);
  update_option ('moderation_notify', 1);
  
}

function click5_disable_comments_dectivationFunction() {
  update_option ('comments_notify', 1);
  update_option ('moderation_notify', 1);
}

register_uninstall_hook(__FILE__, 'click5_disable_comments_uninstallFunction');
register_deactivation_hook( __FILE__, 'click5_disable_comments_dectivationFunction' );